export const xmlhttp = function(path, method, options={}){
  let xhr=new XMLHttpRequest()
  xhr.onreadystatechange = (res)=>{
    if(xhr.readyState === XMLHttpRequest.DONE){
      if(xhr.status>=200 && xhr.status<=300) {
        if(options.cb)options.cb(null, xhr.response)
      } else {
        if(options.cb)options.cb(xhr.status, null)
      }
    }
  }
  xhr.responseType=options.rtype??"arraybuffer"
  xhr.timeout=options.timeout??0
  xhr.open(method, path)
  if(xhr) xhr.send(options.body)
}

function initializingHandler(constr,remap=null){
  return {get:(targ,p,rec)=>{
    if(remap) p=remap(p)
    if(targ[p] === undefined){
      targ[p] = constr()
    }
    return targ[p]
  }}
}
const onfns = {
  down:{label:"down"},
  up:{label:"up"}
}
const remapkey = (key)=>{
  if(key.length == 1) return "Key"+key.toUpperCase();
  return key;
}
export const keys = {
  on: new Proxy(onfns.down,initializingHandler(()=>new Set(),remapkey)),
  onup: new Proxy(onfns.up,initializingHandler(()=>new Set(),remapkey))
}
window.addEventListener("keydown",(ev)=>{
  keys[ev.code]=Date.now();
  let m;
  if(m=onfns.down[ev.code]){
    m.forEach(f=>f(ev))
  }
})
window.addEventListener("keyup",(ev)=>{
  let delt = Date.now()-keys[ev.key];
  keys[ev.code]=0;
  let m;
  if(m=onfns.up[ev.code]){
    m.forEach(f=>f(ev,delt))
  }
})

export const mouseClientPos={x:0,y:0};
window.addEventListener("mousemove",(ev)=>{
  mouseClientPos.x=ev.clientX
  mouseClientPos.y=ev.clientY
})

export function clamp(f,l,h){
  return f<l?l:(f>h?h:f)
}


export class editHistory{
  constructor(maxbsize=2000){
    this.maxbsize = maxbsize;
    this.cb = []
    this.hist =[]
  }
  newBatch(){
    this.hist.push(this.cb)
    console.log(this.cb.length)
    this.cb=[]
  }
  append(offset,oldval){
    if(this.cb.length>this.maxbsize) this.newBatch()
    this.cb.push([offset,oldval])
  }
  revert(){
    if(this.cb.length!=0)this.newBatch()
    if(this.hist.length == 0) return [];
    let arr = this.hist[this.hist.length-1];
    this.hist.length--
    return arr
  }
  
}